import { TestBed, inject } from '@angular/core/testing'
import { MockBackend, MockConnection } from '@angular/http/testing'
import { Http, BaseRequestOptions, Response, ResponseOptions, RequestMethod } from '@angular/http'

import { MainContentService } from './maincontent.service'
import { MainContent } from './maincontent'

describe('MainContentService', function() {
  let subject: MainContentService
  let backend: MockBackend

  beforeEach(function() {

    TestBed.configureTestingModule({
        providers: [
          MainContentService,
          MockBackend,
          BaseRequestOptions,
          {
            provide: Http,
            useFactory: function(mockBackend, defaultOptions) {
              return new Http(mockBackend, defaultOptions);
              },
            deps: [MockBackend, BaseRequestOptions]
          }
        ]
    })

  })

  beforeEach(inject([MainContentService, MockBackend], function(mainContentService, mockBackend) {
    subject = mainContentService
    backend = mockBackend
  }))

  it('should get data', function(done) {

    backend.connections.subscribe(function(connection: MockConnection) {

      let options = new ResponseOptions({ body: {

          "product": [
            {
              "name": "home",
              "erevenueUrl": "https://vaww.vha.esp.va.gov/sites/eBusinessSolutions/SitePages/Home.aspx"
            },
            {
              "name": "eBilling",
              "erevenueUrl": "https://vaww.vha.esp.va.gov/sites/eBusinessSolutions/SitePages/MoreProj.aspx?qproj=eBilling"
            },
            {
              "name": "eInsurance",
              "erevenueUrl": "https://vaww.vha.esp.va.gov/sites/eBusinessSolutions/SitePages/MoreProj.aspx?qproj=eInsurance"
            }
          ]

        }

       })
      connection.mockRespond(new Response(options))
    })

    subject.getContent().subscribe(function(response) {
        expect(response).toEqual(jasmine.any(MainContent))
        expect(response.product.length).toEqual(3)
        expect(response.product[0].name).toEqual('home')
        },
        function(e) {
          console.log(" ERROR:"+e)
        }
    );

    done()
  })

  afterEach(function() {
    TestBed.resetTestingModule()
  })

})
